define('jquery.validate.config', [
    'jquery.validate',
    'jquery.validate.additional-methods',
],
function () {
    $.extend($.validator.prototype, {
        showLabel: function(element, message) {
            var place, placeListItem, group, errorID,
                error = this.errorsFor(element),
                elementID = this.idOrName(element),
                describedBy = $(element).attr('aria-describedby');
            if (error.length) {
                // refresh error/success class
                error.removeClass(this.settings.validClass).addClass(this.settings.errorClass);
                // replace message on existing label
                error.html(message);
            }
            else {
                // create error element
                error = $('<' + this.settings.errorElement + '>')
                    .attr('id', elementID + '-error')
                    .addClass(this.settings.errorClass)
                    .html(message || '');

                // Maintain reference to the element to be placed into the DOM
                place = error;
                // use both label container and errorPlacement (show errors both above form and inline)
                if (this.labelContainer.length) {
                    // use wrapper only for labelContainer
                    if (this.settings.wrapper) {
                        // make sure the element is visible, even in IE
                        // actually showing the wrapped element is handled elsewhere
                        placeListItem = error.hide().show()
                            .wrap('<' + this.settings.wrapper + '/>')
                            .parent();
                    }

                    this.labelContainer.append(placeListItem);
                }

                // clones place to insert according to errorPlacement() or insert after the element
                var placeWithElement = place.clone().attr('id', error.attr('id') + '-inline');
                if (this.settings.errorPlacement) {
                    this.settings.errorPlacement(placeWithElement, $(element));
                }
                else {
                    placeWithElement.insertAfter(element);
                }

                // Link error back to the element
                if (error.is('label')) {
                    // If the error is a label, then associate using 'for'
                    error.attr('for', elementID);
                }
                else if (error.parents("label[for='" + elementID + "']").length === 0) {
                    // If the element is not a child of an associated label, then it's necessary
                    // to explicitly apply aria-describedby

                    errorID = error.attr('id').replace(/(:|\.|\[|\]|\$)/g, '\\$1');
                    // Respect existing non-error aria-describedby
                    if (!describedBy) {
                        describedBy = errorID;
                    }
                    else if (!describedBy.match(new RegExp('\\b' + errorID + '\\b'))) {
                        // Add to end of list if not already present
                        describedBy += ' ' + errorID;
                    }
                    $(element).attr('aria-describedby', describedBy);

                    // If this element is grouped, then assign to all elements in the same group
                    group = this.groups[element.name];
                    if (group) {
                        $.each(this.groups, function(name, testgroup) {
                            if (testgroup === group) {
                                $("[name='" + name + "']", this.currentForm)
                                    .attr('aria-describedby', error.attr('id'));
                            }
                        });
                    }
                }
            }
            if (!message && this.settings.success) {
                error.text('');
                if (typeof this.settings.success === 'string') {
                    error.addClass(this.settings.success);
                }
                else {
                    this.settings.success(error, element);
                }
            }
            this.toShow = this.toShow.add(error);
        },
        errorsFor: function(element) {
            var name = this.idOrName(element),
                describer = $(element).attr('aria-describedby'),
                selector = "label[for='" + name + "'], label[for='" + name + "']";

            // aria-describedby should directly reference the error element
            if (describer) {
                selector = selector + ', #' + describer.replace(/\s+/g, ', #');
            }

            // returns {name}-error-inline and {name}-error
            return $('#' + name + '-error-inline').add(this
                .errors()
                .filter(selector));
        },
    });

    var isValidDate = function(value) {
        var dateArray = value.split('/');
        var month = dateArray[0];
        var day = dateArray[1];
        var year = dateArray[2];

        var isValid = true;

        if (month && month.length === 2) {
            month = parseInt(month, 10);
            isValid = isValid && (month >= 1 && month <= 12);

            if (day && day.length === 2) {
                var daysInMonth;

                day = parseInt(day, 10);

                isValid = isValid && day >= 1;
                switch (month) {
                case 2:
                    daysInMonth = 29; // leap year
                    if (year && year.length === 4 && new Date(parseInt(year, 10), 1, 29).getMonth() !== 1) {
                        daysInMonth = 28;
                    }
                    break;
                case 4:
                case 6:
                case 9:
                case 11:
                    daysInMonth = 30;
                    break;
                case 1:
                case 3:
                case 5:
                case 7:
                case 8:
                case 10:
                case 12:
                    daysInMonth = 31;
                    break;
                }
                isValid = isValid && day <= daysInMonth;

                if (year) {
                    isValid = isValid && year.length === 4;
                }
                else {
                    isValid = false;
                }
            }
            else {
                isValid = false;
            }
        }
        else {
            isValid = false;
        }

        return isValid;
    };

    // not converting to Date object first because event is called on keyup
    $.validator.addMethod('formattedDate', function(value, element) {
        var execDate = (/\d{2}\/\d{2}\/\d{4}/).exec(value);

        if (execDate != null) {
            var startIndexOfDate = execDate.index;

            return this.optional(element) || isValidDate(value.substring(startIndexOfDate, startIndexOfDate + 10));
        }
        return this.optional(element);

    }, $.validator.format('Please enter a valid Date.'));

    $.validator.addMethod('dateInRange', function(value, element, params) {
        var startDate = new Date(params[0]);
        startDate.setHours(0, 0, 0, 0);
        var endDate = new Date(params[1]);
        endDate.setHours(0, 0, 0, 0);
        var valueDate = new Date(value);
        valueDate.setHours(0, 0, 0, 0);

        return this.optional(element) || (valueDate.toString() !== 'Invalid Date' && valueDate >= startDate && valueDate <= endDate);
    }, $.validator.format('Please enter a date between {0} and {1}.'));

    $.validator.addMethod("uniqueDate", function(value, element, params) {

        //create a selector that finds all text inputs (date inputs that have the class params and are not itself.
        var selector = $.validator.format(".{0} :text:not(#{1})", params, element.id);

        //find those elements from the selector.
        var $matches = $(selector).filter(function(index, item) {

            //empty values do not count.
            return value != "" && value == $(item).val();
        });

        return $matches.length === 0;
    }, $.validator.format("The Date Entered is not unique."));

    $.validator.classRuleSettings.unique = {
        unique: true
    };

    jQuery.validator.addMethod("zipCode", function(value, element) {
        return this.optional(element) || /^\d{5}(?:[-\s]\d{4})?$/.test(value);
    }, "Please provide a valid zip code.");

});
